define(['jQuery', 'angular', 'angularUiBootstrap'], function ($, angular) {
	"use strict";

	angular.module('accessibleDatePickerServices', ['ui.bootstrap'])
	.directive('scrollToValue', function ($timeout) {
		return {
			restrict: 'A',
			link: function (scope, element, attrs) {
				function scrollMe(val) {
					element.find('[data-value="' + val + '"]').each(function () {
						var $li = $(this).closest('li'),
							$ul = $li.closest('ul'),
							$b = $ul.closest('b'),
							scrollTop = ($ul.children().index($li)) * ($li.height());
						$b.scrollTop(scrollTop);
						$timeout(function () {
							scope.$digest();
						});
					});
				}

				scope.$watch(attrs.scrollToValue, function(){
					$timeout(function() {
						scrollMe(scope.$eval(attrs.scrollToValue));
					});
				});

				var timeoutPromise;
				element.on('scroll', function (e) {
					$timeout.cancel(timeoutPromise);
					var currentTarget = e.currentTarget;
					timeoutPromise = $timeout(function () {
						var $ul = $(currentTarget).find("ul"),//
							$lis = $ul.children(),
							lineHeight = $lis.eq(0).height(),
							top = $ul.position().top,
							n = Math.round(-top/lineHeight),
							$buttons = $ul.find('button'),
							$button = $lis.eq(n).find('button'),
							$prevSelected = $ul.find('.selected'),
							prevSelectedIndex = $buttons.index($prevSelected),
							typ = $ul.parent()[0].className;
						if (!$button.prop('disabled')) {
							$ul.scrollTop((-n * lineHeight) + lineHeight);
							scope.dateChosen[typ] = $button.attr('data-value');
						} else {
							$button = $ul.find('button:enabled').eq(prevSelectedIndex > n ? 0 : -1);
							scope.dateChosen[typ] = $button.attr('data-value');
							n = parseFloat(scope.dateChosen[typ]);
							$ul.scrollTop((-n * lineHeight) + lineHeight);
						}
						scope.$digest();
					}, 500);

				});
			}
		};
	})
	.directive('focusMe', function ($timeout) {
		var timeoutPromise = null;
		return {
			restrict: 'A',
			link: function (scope, element, attrs) {
				scope.$watch(attrs.focusMe, function() {
					if (scope.$eval(attrs.focusMe)) {
						$timeout(function () {
							element.focus();
						}, 0);
					}
				});
				scope.onFocus = function(){
					$timeout.cancel(timeoutPromise);
					timeoutPromise = $timeout(function () {
						if(scope.dateChosen[attrs.type] !== parseInt(attrs.value)){
							scope.dateChosen[attrs.type] = parseInt(attrs.value);
						}
					}, 0);
				};
			}
		};
	})
	.directive('accessibleDatePicker', function ($modal, $filter, $timeout) {
		return {
			restrict: 'A',
			require: 'ngModel',
			scope: {
				allowedDateRange: "=",
				disableDaySelection: "=?",
				disableMonthSelection: "=?"
			},
			link: function (scope, element, attrs, ngModelCtrl) {
				element.bind('click', function (e) {
					e.preventDefault();
					var modalInstance = $modal.open({
						templateUrl: 'src/ui-components/form/controls/simple/accessibledatepicker/accessibledatepicker_template.html',
						controller:  'accessibleDatePickerController',
						windowClass: scope.disableMonthSelection ? 'date-picker-modal-hidden-month' : (scope.disableDaySelection ? 'date-picker-modal-hidden-day' : 'date-picker-modal'),
						resolve: {
							currentvalue: function () {
								return ngModelCtrl.$modelValue;
							},
							allowedDateRange: function($q) {
								return $q.when(scope.allowedDateRange);
							},
							disableDaySelection: function($q) {
								return $q.when(scope.disableDaySelection);
							},
							disableMonthSelection: function($q) {
								return $q.when(scope.disableMonthSelection);
							}
						}
					});

					modalInstance.result.then(function (value) {
						var formattedDate = $filter('date')
						(new Date([value.month, value.day, value.year].join("/")), attrs.dateFormat);
						ngModelCtrl.$setViewValue(formattedDate);
						ngModelCtrl.$render();
						$timeout(function () {
							element.focus();
						}, 600);
					}, function () {
						$timeout(function () {
							element.focus();
						}, 600);
					});
				});
			}
		};
	})
	.controller('accessibleDatePickerController', function ($scope, $modalInstance, currentvalue, allowedDateRange, disableDaySelection, disableMonthSelection) {
		var currentDate = new Date();

		var parseDate = function (dateObj) {
			return {
				year:  dateObj.getFullYear(),
				month: dateObj.getMonth() + 1,
				day:   dateObj.getDate()
			}
		};

		$scope.disableDaySelection = disableDaySelection;
		$scope.disableMonthSelection = disableMonthSelection;
		$scope.getDate = function (dateObj) {
			return new Date(dateObj.year, dateObj.month - 1, dateObj.day);
		};

		if (typeof currentvalue === "string") {
			if (disableMonthSelection) {
				if (currentvalue.indexOf("01/01/") === -1) {
					currentvalue = "01/01/" + currentvalue;
				}
			} else if (disableDaySelection && currentvalue.length > 2 && currentvalue.indexOf("/01") !== 2) {
				currentvalue = currentvalue.slice(0, 2) + "/01" + currentvalue.slice(2, currentvalue.length);
			}
		}

		$scope.TODAY = parseDate(currentDate);
		$scope.DATE_MIN = allowedDateRange && allowedDateRange.min ? parseDate(new Date(allowedDateRange.min)) : parseDate(new Date("01/01/1900"));
		$scope.DATE_MAX = allowedDateRange && allowedDateRange.max ? parseDate(new Date(allowedDateRange.max)) : $scope.TODAY;

		$scope.WEEKDAYS = ["Su ", "Mo ", "Tu ", "We ", "Th ", "Fr ", "Sa "];
		$scope.MONTHS = ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'];
		$scope.focusOn = 'month';

		$scope.forNumber = function (num) {
			return new Array(num);
		};
		$scope.getYears = function (min, max) {
			var years = [],
				index;
			for (index = min; index <= max; index++) {
				years.push(index);
			}
			return years;
		};

		$scope.dateChosen = /^\d{2}\/\d{2}\/\d{4}$/.test(currentvalue) && (new Date(currentvalue)).toString() !== "Invalid Date"?
			parseDate(new Date(currentvalue)) : $scope.TODAY;

		$scope.$watch('dateChosen', function () {
			$scope.dateChosen.day   = parseInt($scope.dateChosen.day);
			$scope.dateChosen.month = parseInt($scope.dateChosen.month);
			$scope.dateChosen.year  = parseInt($scope.dateChosen.year);

			if ($scope.dateChosen.month > 12) {
				$scope.dateChosen.month = 12;
			}
			if ($scope.dateChosen.month <= 0) {
				$scope.dateChosen.month = 1;
			}
			if ($scope.dateChosen.year > $scope.DATE_MAX.year) {
				$scope.dateChosen.year = $scope.DATE_MAX.year;
			}
			if ($scope.dateChosen.year < $scope.DATE_MIN.year) {
				$scope.dateChosen.year = $scope.DATE_MIN.year;
			}
			if ($scope.dateChosen.day <= 0) {
				$scope.dateChosen.day = 1;
			}
			if ($scope.dateChosen.day > $scope.daysInMonth()) {
				$scope.dateChosen.day = $scope.daysInMonth();
			}
			var d = new Date($scope.dateChosen.year, $scope.dateChosen.month - 1, $scope.dateChosen.day);
			if (d > $scope.getDate($scope.DATE_MAX)) {
				$.extend($scope.dateChosen, $scope.DATE_MAX);
			}
			if (d < $scope.getDate($scope.DATE_MIN)) {
				$.extend($scope.dateChosen, $scope.DATE_MIN);
			}
		}, true);

		$scope.daysInMonth = function () {
			return $scope.dateChosen.year === undefined || $scope.dateChosen.month === undefined ? 31 :
				new Date($scope.dateChosen.year, $scope.dateChosen.month, 0).getDate();
		};

		$scope.isMinYear = function () {
			return $scope.DATE_MIN.year === $scope.dateChosen.year;
		};

		$scope.isMaxYear = function () {
			return $scope.DATE_MAX.year === $scope.dateChosen.year;
		};

		$scope.underMinMonth = function (month) {
			return $scope.isMinYear() && $scope.DATE_MIN.month > month;
		};

		$scope.aboveMaxMonth = function (month) {
			return $scope.isMaxYear() && $scope.DATE_MAX.month < month;
		};

		$scope.underMinDate = function (day) {
			return $scope.isMinYear() && $scope.DATE_MIN.month === $scope.dateChosen.month && $scope.DATE_MIN.day > day;
		};

		$scope.aboveMaxDate = function (day) {
			return $scope.isMaxYear() && $scope.DATE_MAX.month === $scope.dateChosen.month && $scope.DATE_MAX.day < day;
		};

		$scope.dateclick = function (typ, value) {
			$scope.dateChosen[typ] = value;
			$scope.focusOn = $scope.nextFocus[$scope.focusOn];
		};

		$scope.close = function (e) {
			$modalInstance.dismiss('cancel');
			e.preventDefault();
			return false;
		};
		$scope.setkey = function (e) {
			e.preventDefault();
			switch (e.which) {
				case 13:
					$scope.set();
					break;
			}
			$scope.columnKeyDown(e);
		};
		$scope.set = function (e) {
			if (e) {
				e.preventDefault();
			}
			$modalInstance.close($scope.dateChosen);
			return false;
		};

		$scope.detectEscape = function (e) {
			if (e.which === 27) {
				$modalInstance.dismiss('cancel');
			}
		};

		$scope.formatHeading = function () {
			var calcDate = new Date($scope.dateChosen.year, $scope.dateChosen.month - 1, $scope.dateChosen.day);
			return calcDate.toDateString() === currentDate.toDateString() ?
				"Today" : calcDate.toDateString();
		};

		$scope.nextFocus = {month:'day', day:'year', year:'set', set:'close', close:'month'};
		$scope.prevFocus = {month:'close', close:'set', set:'year', year:'day', day:'month'};

		$scope.columnKeyDown = function (e) {
			var tab = function (direction){
					if(direction === 'next'){
						$scope.focusOn = $scope.nextFocus[$scope.focusOn];
					} else if (direction === 'prev') {
						$scope.focusOn = $scope.prevFocus[$scope.focusOn];
					}
				},
				ifPossible = function (dir) {
					if ($scope.focusOn === 'year') {
						$scope.dateChosen.year += dir;
					} else if ($scope.focusOn === 'month') {
						$scope.dateChosen.month += dir;
					} else if ($scope.focusOn === 'day') {
						$scope.dateChosen.day += dir;
					}
				};
			e.preventDefault();
			switch (e.which) {
				case 9:
					if (e.shiftKey) {
						tab('prev');
					} else {
						tab('next');
					}
					break;
				case 37:
					tab('prev');
					break;
				case 38:
					ifPossible(-1);
					break;
				case 39:
					tab('next');
					break;
				case 40:
					ifPossible(1);
					break;
			}
		};

		$scope.cancelKeyDown = function (e) {
			e.preventDefault();
			switch (e.which) {
				case 13:
					$modalInstance.dismiss('cancel');
					break;
			}

			$scope.columnKeyDown(e);
		};
	});
});
